/*	TO DO:
*	-Comment MyTimeCtrl
*	
*
*/
#include "wx/wx.h"
#include <wx/cmdline.h>
#include <wx/config.h>
#include <wx/fileconf.h>
#include <wx/wfstream.h>

#include "App.h"

#include <ctype.h>

IMPLEMENT_APP(App)

App::App() : _frame(0)
{
}

//Constructor for App class.
App::~App()
{
	_debuglog.close();
	std::cerr.rdbuf(_old_cerr);
}

//Handles any fatal exceptions that occur by prompting a message box to the user.
void App::OnFatalException()
{
	wxMessageBox(wxT("Talking Head did something wrong and is about to shut itself down!\nPlease report this problem to Chucobo222@netscape.net if you think it is a bug.\n\nThank you for your patience and cooperation.\n-Talking Head Team-"), wxT("Fatal Talking Head Error"), wxICON_ERROR | wxCENTRE, 0);
}

// 'Main' equivalent, the program "starts" here
bool App::OnInit()
{
	wxHandleFatalExceptions();

	_old_cerr = std::cerr.rdbuf();
	_debuglog.open("debug.log", std::ios_base::out);
	std::cerr.rdbuf(_debuglog.rdbuf());

	SetVendorName(_T("THT"));
	SetAppName(_T("Talking Head"));

	//reads in the start-up properties from the config file
	wxFileInputStream st(wxT("talkinghead.ini"));
	wxFileConfig *pConfig = new wxFileConfig(st);
    wxConfigBase::Set(pConfig);

	//loads the start-up properties from the config file
	long left, top, width, height;
	pConfig->Read(_T("Window/Left"), &left, 400);
	pConfig->Read(_T("Window/Top"), &top, 100);
	pConfig->Read(_T("Window/Width"), &width, 500);
	pConfig->Read(_T("Window/Height"), &height, 500);

	_frame = new Frame(_("Talking Head"), wxPoint(left, top), wxSize(width, height), wxDEFAULT_FRAME_STYLE);

	_frame->Show(TRUE);
	SetTopWindow(_frame);

	return wxApp::OnInit();
}

bool App::OnCmdLineParsed(wxCmdLineParser& parser)
{
	wxString names[3];
	
	wxConfigBase *pConfig = wxConfigBase::Get();
    wxString dummy;
	pConfig->Read(_T("MPEG-4/Initial-FAP"), &dummy, wxT("Faps/joy.fap"));
	names[0] = dummy;
	pConfig->Read(_T("MPEG-4/Initial-FDP"), &dummy, wxT("alice.fdp"));
	names[1] = dummy;
	pConfig->Read(_T("MPEG-4/Initial-FDP-Path"), &dummy, wxT("Faces/alice/"));
	names[2] = dummy;
		
	for(size_t x = 0; x < parser.GetParamCount(); ++x)
	{
		names[x] = parser.GetParam(x);
	}

	_frame->SetFAP(names[0]);
	_frame->SetFDP(names[1], names[2]);

	_scriptEvents = new ScriptEvents(_frame);
	_frame->PlayVideo("Alice Intro.avi");

	return true;
}



